%------------------------------------------------------------------------------
% File     : ITP096^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer Liouville_Numbers problem prob_235__5867912_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : Liouville_Numbers/prob_235__5867912_1 [Des21]

% Status   : ContradictoryAxioms
% Rating   : 0.67 v9.0.0, 0.33 v8.1.0, 0.75 v7.5.0
% Syntax   : Number of formulae    :  402 ( 128 unt;  62 typ;   0 def)
%            Number of atoms       :  862 ( 330 equ;   0 cnn)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives : 3340 (  87   ~;  21   |;  37   &;2853   @)
%                                         (   0 <=>; 342  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   19 (   6 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   53 (  53   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   61 (  59 usr;   6 con; 0-3 aty)
%            Number of variables   :  730 (  12   ^; 654   !;  14   ?; 730   :)
%                                         (  50  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:26:21.522
%------------------------------------------------------------------------------
% Could-be-implicit typings (4)
thf(ty_t_Real_Oreal,type,
    real: $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_Int_Oint,type,
    int: $tType ).

% Explicit typings (58)
thf(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

thf(sy_cl_Power_Opower,type,
    power: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Nat_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Num_Oneg__numeral,type,
    neg_numeral: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oidom__abs__sgn,type,
    idom_abs_sgn: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ozero__less__one,type,
    zero_less_one: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Odivision__ring,type,
    division_ring: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Ofield__abs__sgn,type,
    field_abs_sgn: 
      !>[A: $tType] : $o ).

thf(sy_cl_Parity_Osemiring__bits,type,
    semiring_bits: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Osemidom__divide,type,
    semidom_divide: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Osemigroup__mult,type,
    semigroup_mult: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocomm__monoid__diff,type,
    comm_monoid_diff: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocancel__comm__monoid__add,type,
    cancel1352612707id_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oordered__ab__group__add__abs,type,
    ordere142940540dd_abs: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Osemiring__no__zero__divisors,type,
    semiri1193490041visors: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Olinordered__nonzero__semiring,type,
    linord1659791738miring: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Osemiring__1__no__zero__divisors,type,
    semiri134348788visors: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Osemiring__no__zero__divisors__cancel,type,
    semiri1923998003cancel: 
      !>[A: $tType] : $o ).

thf(sy_cl_Euclidean__Division_Oeuclidean__semiring__cancel,type,
    euclid191655569cancel: 
      !>[A: $tType] : $o ).

thf(sy_c_Groups_Oabs__class_Oabs,type,
    abs_abs: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

thf(sy_c_Liouville__Numbers__Mirabelle__ayxpmfmawz_Oliouville,type,
    liouvi603386861uville: real > ( nat > int ) > ( nat > int ) > $o ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Polynomial_Oalgebraic,type,
    algebraic: 
      !>[A: $tType] : ( A > $o ) ).

thf(sy_c_Power_Opower__class_Opower,type,
    power_power: 
      !>[A: $tType] : ( A > nat > A ) ).

thf(sy_c_Rat_Ofield__char__0__class_ORats,type,
    field_char_0_Rats: 
      !>[A: $tType] : ( set @ A ) ).

thf(sy_c_Rings_Odivide__class_Odivide,type,
    divide_divide: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_c____,type,
    c: real ).

thf(sy_v_m____,type,
    m: nat ).

thf(sy_v_n____,type,
    n: nat ).

thf(sy_v_p,type,
    p: nat > int ).

thf(sy_v_q,type,
    q: nat > int ).

thf(sy_v_r____,type,
    r: nat ).

thf(sy_v_x,type,
    x: real ).

% Relevant facts (253)
thf(fact_0__092_060open_062algebraic_Ax_092_060close_062,axiom,
    algebraic @ real @ x ).

% \<open>algebraic x\<close>
thf(fact_1_liouville__axioms,axiom,
    liouvi603386861uville @ x @ p @ q ).

% liouville_axioms
thf(fact_2_denom__gt__1,axiom,
    ! [N: nat] : ( ord_less @ int @ ( one_one @ int ) @ ( q @ N ) ) ).

% denom_gt_1
thf(fact_3_cn_I1_J,axiom,
    ord_less @ real @ ( zero_zero @ real ) @ c ).

% cn(1)
thf(fact_4_irrational,axiom,
    ~ ( member @ real @ x @ ( field_char_0_Rats @ real ) ) ).

% irrational
thf(fact_5__092_060open_0621_A_060_Aq_Am_092_060close_062,axiom,
    ord_less @ int @ ( one_one @ int ) @ ( q @ m ) ).

% \<open>1 < q m\<close>
thf(fact_6_liouville_Odenom__gt__1,axiom,
    ! [X: real,P: nat > int,Q: nat > int,N: nat] :
      ( ( liouvi603386861uville @ X @ P @ Q )
     => ( ord_less @ int @ ( one_one @ int ) @ ( Q @ N ) ) ) ).

% liouville.denom_gt_1
thf(fact_7_liouville_Oirrational,axiom,
    ! [X: real,P: nat > int,Q: nat > int] :
      ( ( liouvi603386861uville @ X @ P @ Q )
     => ~ ( member @ real @ X @ ( field_char_0_Rats @ real ) ) ) ).

% liouville.irrational
thf(fact_8__092_060open_062_092_060bar_062x_A_N_Areal__of__int_A_Ip_Am_J_A_P_Areal__of__int_A_Iq_Am_J_092_060bar_062_A_060_Ac_A_P_Areal__of__int_A_Iq_Am_J_A_094_An_092_060close_062,axiom,
    ord_less @ real @ ( abs_abs @ real @ ( minus_minus @ real @ x @ ( divide_divide @ real @ ( ring_1_of_int @ real @ ( p @ m ) ) @ ( ring_1_of_int @ real @ ( q @ m ) ) ) ) ) @ ( divide_divide @ real @ c @ ( power_power @ real @ ( ring_1_of_int @ real @ ( q @ m ) ) @ n ) ) ).

% \<open>\<bar>x - real_of_int (p m) / real_of_int (q m)\<bar> < c / real_of_int (q m) ^ n\<close>
thf(fact_9__092_060open_0620_A_060_Aq_Am_A_092_060Longrightarrow_062_Ac_A_P_Areal__of__int_A_Iq_Am_J_A_094_An_A_060_A_092_060bar_062x_A_N_Areal__of__int_A_Ip_Am_J_A_P_Areal__of__int_A_Iq_Am_J_092_060bar_062_092_060close_062,axiom,
    ( ( ord_less @ int @ ( zero_zero @ int ) @ ( q @ m ) )
   => ( ord_less @ real @ ( divide_divide @ real @ c @ ( power_power @ real @ ( ring_1_of_int @ real @ ( q @ m ) ) @ n ) ) @ ( abs_abs @ real @ ( minus_minus @ real @ x @ ( divide_divide @ real @ ( ring_1_of_int @ real @ ( p @ m ) ) @ ( ring_1_of_int @ real @ ( q @ m ) ) ) ) ) ) ) ).

% \<open>0 < q m \<Longrightarrow> c / real_of_int (q m) ^ n < \<bar>x - real_of_int (p m) / real_of_int (q m)\<bar>\<close>
thf(fact_10_approx__int__pos,axiom,
    ! [N: nat] : ( ord_less @ real @ ( zero_zero @ real ) @ ( abs_abs @ real @ ( minus_minus @ real @ x @ ( divide_divide @ real @ ( ring_1_of_int @ real @ ( p @ N ) ) @ ( ring_1_of_int @ real @ ( q @ N ) ) ) ) ) ) ).

% approx_int_pos
thf(fact_11_not__gr__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ~ ( ord_less @ A @ ( zero_zero @ A ) @ N ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% not_gr_zero
thf(fact_12_of__int__1__less__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less @ A @ ( one_one @ A ) @ ( ring_1_of_int @ A @ Z ) )
          = ( ord_less @ int @ ( one_one @ int ) @ Z ) ) ) ).

% of_int_1_less_iff
thf(fact_13_of__int__less__1__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less @ A @ ( ring_1_of_int @ A @ Z ) @ ( one_one @ A ) )
          = ( ord_less @ int @ Z @ ( one_one @ int ) ) ) ) ).

% of_int_less_1_iff
thf(fact_14_less__numeral__extra_I1_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ( ord_less @ A @ ( zero_zero @ A ) @ ( one_one @ A ) ) ) ).

% less_numeral_extra(1)
thf(fact_15_zero__less__one,axiom,
    ! [A: $tType] :
      ( ( zero_less_one @ A )
     => ( ord_less @ A @ ( zero_zero @ A ) @ ( one_one @ A ) ) ) ).

% zero_less_one
thf(fact_16_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ~ ( ord_less @ A @ ( one_one @ A ) @ ( zero_zero @ A ) ) ) ).

% not_one_less_zero
thf(fact_17_abs__idempotent,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A] :
          ( ( abs_abs @ A @ ( abs_abs @ A @ A2 ) )
          = ( abs_abs @ A @ A2 ) ) ) ).

% abs_idempotent
thf(fact_18_abs__abs,axiom,
    ! [A: $tType] :
      ( ( idom_abs_sgn @ A )
     => ! [A2: A] :
          ( ( abs_abs @ A @ ( abs_abs @ A @ A2 ) )
          = ( abs_abs @ A @ A2 ) ) ) ).

% abs_abs
thf(fact_19_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ! [W: int,Z: int] :
          ( ( ( ring_1_of_int @ A @ W )
            = ( ring_1_of_int @ A @ Z ) )
          = ( W = Z ) ) ) ).

% of_int_eq_iff
thf(fact_20_cancel__comm__monoid__add__class_Odiff__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [A2: A] :
          ( ( minus_minus @ A @ A2 @ A2 )
          = ( zero_zero @ A ) ) ) ).

% cancel_comm_monoid_add_class.diff_cancel
thf(fact_21_diff__zero,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [A2: A] :
          ( ( minus_minus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% diff_zero
thf(fact_22_zero__diff,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_diff @ A )
     => ! [A2: A] :
          ( ( minus_minus @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% zero_diff
thf(fact_23_diff__0__right,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A2: A] :
          ( ( minus_minus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% diff_0_right
thf(fact_24_diff__self,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A2: A] :
          ( ( minus_minus @ A @ A2 @ A2 )
          = ( zero_zero @ A ) ) ) ).

% diff_self
thf(fact_25_div__by__0,axiom,
    ! [A: $tType] :
      ( ( semidom_divide @ A )
     => ! [A2: A] :
          ( ( divide_divide @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% div_by_0
thf(fact_26_div__0,axiom,
    ! [A: $tType] :
      ( ( semidom_divide @ A )
     => ! [A2: A] :
          ( ( divide_divide @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% div_0
thf(fact_27_div__by__1,axiom,
    ! [A: $tType] :
      ( ( semidom_divide @ A )
     => ! [A2: A] :
          ( ( divide_divide @ A @ A2 @ ( one_one @ A ) )
          = A2 ) ) ).

% div_by_1
thf(fact_28_abs__zero,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ( ( abs_abs @ A @ ( zero_zero @ A ) )
        = ( zero_zero @ A ) ) ) ).

% abs_zero
thf(fact_29_abs__eq__0,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A] :
          ( ( ( abs_abs @ A @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% abs_eq_0
thf(fact_30_abs__0__eq,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A] :
          ( ( ( zero_zero @ A )
            = ( abs_abs @ A @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% abs_0_eq
thf(fact_31_abs__0,axiom,
    ! [A: $tType] :
      ( ( idom_abs_sgn @ A )
     => ( ( abs_abs @ A @ ( zero_zero @ A ) )
        = ( zero_zero @ A ) ) ) ).

% abs_0
thf(fact_32_abs__1,axiom,
    ! [A: $tType] :
      ( ( idom_abs_sgn @ A )
     => ( ( abs_abs @ A @ ( one_one @ A ) )
        = ( one_one @ A ) ) ) ).

% abs_1
thf(fact_33_of__int__diff,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ! [W: int,Z: int] :
          ( ( ring_1_of_int @ A @ ( minus_minus @ int @ W @ Z ) )
          = ( minus_minus @ A @ ( ring_1_of_int @ A @ W ) @ ( ring_1_of_int @ A @ Z ) ) ) ) ).

% of_int_diff
thf(fact_34_of__int__power__eq__of__int__cancel__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ! [X: int,B: int,W: nat] :
          ( ( ( ring_1_of_int @ A @ X )
            = ( power_power @ A @ ( ring_1_of_int @ A @ B ) @ W ) )
          = ( X
            = ( power_power @ int @ B @ W ) ) ) ) ).

% of_int_power_eq_of_int_cancel_iff
thf(fact_35_of__int__eq__of__int__power__cancel__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ! [B: int,W: nat,X: int] :
          ( ( ( power_power @ A @ ( ring_1_of_int @ A @ B ) @ W )
            = ( ring_1_of_int @ A @ X ) )
          = ( ( power_power @ int @ B @ W )
            = X ) ) ) ).

% of_int_eq_of_int_power_cancel_iff
thf(fact_36_of__int__power,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ! [Z: int,N: nat] :
          ( ( ring_1_of_int @ A @ ( power_power @ int @ Z @ N ) )
          = ( power_power @ A @ ( ring_1_of_int @ A @ Z ) @ N ) ) ) ).

% of_int_power
thf(fact_37_of__int__abs,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [X: int] :
          ( ( ring_1_of_int @ A @ ( abs_abs @ int @ X ) )
          = ( abs_abs @ A @ ( ring_1_of_int @ A @ X ) ) ) ) ).

% of_int_abs
thf(fact_38__092_060open_062_092_060And_062thesis_O_A_I_092_060And_062c_An_O_A_092_060lbrakk_0620_A_060_Ac_059_A_092_060And_062p_Aq_O_A0_A_060_Aq_A_092_060Longrightarrow_062_Ac_A_P_Areal__of__int_Aq_A_094_An_A_060_A_092_060bar_062x_A_N_Areal__of__int_Ap_A_P_Areal__of__int_Aq_092_060bar_062_092_060rbrakk_062_A_092_060Longrightarrow_062_Athesis_J_A_092_060Longrightarrow_062_Athesis_092_060close_062,axiom,
    ~ ! [C: real] :
        ( ( ord_less @ real @ ( zero_zero @ real ) @ C )
       => ! [N2: nat] :
            ~ ! [P2: int,Q2: int] :
                ( ( ord_less @ int @ ( zero_zero @ int ) @ Q2 )
               => ( ord_less @ real @ ( divide_divide @ real @ C @ ( power_power @ real @ ( ring_1_of_int @ real @ Q2 ) @ N2 ) ) @ ( abs_abs @ real @ ( minus_minus @ real @ x @ ( divide_divide @ real @ ( ring_1_of_int @ real @ P2 ) @ ( ring_1_of_int @ real @ Q2 ) ) ) ) ) ) ) ).

% \<open>\<And>thesis. (\<And>c n. \<lbrakk>0 < c; \<And>p q. 0 < q \<Longrightarrow> c / real_of_int q ^ n < \<bar>x - real_of_int p / real_of_int q\<bar>\<rbrakk> \<Longrightarrow> thesis) \<Longrightarrow> thesis\<close>
thf(fact_39__092_060open_062_092_060And_062thesis_O_A_I_092_060And_062c_An_O_A_092_060lbrakk_0620_A_060_Ac_059_A_092_060And_062p_Aq_O_A0_A_060_Aq_A_092_060Longrightarrow_062_Ac_A_P_Areal__of__int_Aq_A_094_An_A_060_A_092_060bar_062x_A_N_Areal__of__int_Ap_A_P_Areal__of__int_Aq_092_060bar_062_092_060rbrakk_062_A_092_060Longrightarrow_062_Athesis_J_A_092_060Longrightarrow_062_Athesis_092_060close_062,axiom,
    ~ ! [C: real] :
        ( ( ord_less @ real @ ( zero_zero @ real ) @ C )
       => ! [N2: nat] :
            ~ ! [P2: int,Q2: int] :
                ( ( ord_less @ int @ ( zero_zero @ int ) @ Q2 )
               => ( ord_less @ real @ ( divide_divide @ real @ C @ ( power_power @ real @ ( ring_1_of_int @ real @ Q2 ) @ N2 ) ) @ ( abs_abs @ real @ ( minus_minus @ real @ x @ ( divide_divide @ real @ ( ring_1_of_int @ real @ P2 ) @ ( ring_1_of_int @ real @ Q2 ) ) ) ) ) ) ) ).

% \<open>\<And>thesis. (\<And>c n. \<lbrakk>0 < c; \<And>p q. 0 < q \<Longrightarrow> c / real_of_int q ^ n < \<bar>x - real_of_int p / real_of_int q\<bar>\<rbrakk> \<Longrightarrow> thesis) \<Longrightarrow> thesis\<close>
thf(fact_40_diff__gt__0__iff__gt,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( minus_minus @ A @ A2 @ B ) )
          = ( ord_less @ A @ B @ A2 ) ) ) ).

% diff_gt_0_iff_gt
thf(fact_41_diff__numeral__special_I9_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A )
     => ( ( minus_minus @ A @ ( one_one @ A ) @ ( one_one @ A ) )
        = ( zero_zero @ A ) ) ) ).

% diff_numeral_special(9)
thf(fact_42_div__self,axiom,
    ! [A: $tType] :
      ( ( semidom_divide @ A )
     => ! [A2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ A2 @ A2 )
            = ( one_one @ A ) ) ) ) ).

% div_self
thf(fact_43_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P3: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P3 ) )
      = ( P3 @ A2 ) ) ).

% mem_Collect_eq
thf(fact_44_Collect__mem__eq,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( collect @ A
        @ ^ [X2: A] : ( member @ A @ X2 @ A3 ) )
      = A3 ) ).

% Collect_mem_eq
thf(fact_45_Collect__cong,axiom,
    ! [A: $tType,P3: A > $o,Q3: A > $o] :
      ( ! [X3: A] :
          ( ( P3 @ X3 )
          = ( Q3 @ X3 ) )
     => ( ( collect @ A @ P3 )
        = ( collect @ A @ Q3 ) ) ) ).

% Collect_cong
thf(fact_46_zero__less__abs__iff,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( abs_abs @ A @ A2 ) )
          = ( A2
           != ( zero_zero @ A ) ) ) ) ).

% zero_less_abs_iff
thf(fact_47_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ! [Z: int] :
          ( ( ( ring_1_of_int @ A @ Z )
            = ( zero_zero @ A ) )
          = ( Z
            = ( zero_zero @ int ) ) ) ) ).

% of_int_eq_0_iff
thf(fact_48_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ! [Z: int] :
          ( ( ( zero_zero @ A )
            = ( ring_1_of_int @ A @ Z ) )
          = ( Z
            = ( zero_zero @ int ) ) ) ) ).

% of_int_0_eq_iff
thf(fact_49_of__int__0,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ( ( ring_1_of_int @ A @ ( zero_zero @ int ) )
        = ( zero_zero @ A ) ) ) ).

% of_int_0
thf(fact_50_of__int__less__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [W: int,Z: int] :
          ( ( ord_less @ A @ ( ring_1_of_int @ A @ W ) @ ( ring_1_of_int @ A @ Z ) )
          = ( ord_less @ int @ W @ Z ) ) ) ).

% of_int_less_iff
thf(fact_51_of__int__eq__1__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ! [Z: int] :
          ( ( ( ring_1_of_int @ A @ Z )
            = ( one_one @ A ) )
          = ( Z
            = ( one_one @ int ) ) ) ) ).

% of_int_eq_1_iff
thf(fact_52_of__int__1,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ( ( ring_1_of_int @ A @ ( one_one @ int ) )
        = ( one_one @ A ) ) ) ).

% of_int_1
thf(fact_53_approx__int,axiom,
    ! [N: nat] : ( ord_less @ real @ ( abs_abs @ real @ ( minus_minus @ real @ x @ ( divide_divide @ real @ ( ring_1_of_int @ real @ ( p @ N ) ) @ ( ring_1_of_int @ real @ ( q @ N ) ) ) ) ) @ ( divide_divide @ real @ ( one_one @ real ) @ ( power_power @ real @ ( ring_1_of_int @ real @ ( q @ N ) ) @ N ) ) ) ).

% approx_int
thf(fact_54__092_060open_062_092_060bar_062x_A_N_Areal__of__int_A_Ip_Am_J_A_P_Areal__of__int_A_Iq_Am_J_092_060bar_062_A_060_A1_A_P_Areal__of__int_A_Iq_Am_J_A_094_Am_092_060close_062,axiom,
    ord_less @ real @ ( abs_abs @ real @ ( minus_minus @ real @ x @ ( divide_divide @ real @ ( ring_1_of_int @ real @ ( p @ m ) ) @ ( ring_1_of_int @ real @ ( q @ m ) ) ) ) ) @ ( divide_divide @ real @ ( one_one @ real ) @ ( power_power @ real @ ( ring_1_of_int @ real @ ( q @ m ) ) @ m ) ) ).

% \<open>\<bar>x - real_of_int (p m) / real_of_int (q m)\<bar> < 1 / real_of_int (q m) ^ m\<close>
thf(fact_55_cn_I2_J,axiom,
    ! [Q: int,P: int] :
      ( ( ord_less @ int @ ( zero_zero @ int ) @ Q )
     => ( ord_less @ real @ ( divide_divide @ real @ c @ ( power_power @ real @ ( ring_1_of_int @ real @ Q ) @ n ) ) @ ( abs_abs @ real @ ( minus_minus @ real @ x @ ( divide_divide @ real @ ( ring_1_of_int @ real @ P ) @ ( ring_1_of_int @ real @ Q ) ) ) ) ) ) ).

% cn(2)
thf(fact_56_of__int__power__less__of__int__cancel__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [X: int,B: int,W: nat] :
          ( ( ord_less @ A @ ( ring_1_of_int @ A @ X ) @ ( power_power @ A @ ( ring_1_of_int @ A @ B ) @ W ) )
          = ( ord_less @ int @ X @ ( power_power @ int @ B @ W ) ) ) ) ).

% of_int_power_less_of_int_cancel_iff
thf(fact_57_of__int__less__of__int__power__cancel__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [B: int,W: nat,X: int] :
          ( ( ord_less @ A @ ( power_power @ A @ ( ring_1_of_int @ A @ B ) @ W ) @ ( ring_1_of_int @ A @ X ) )
          = ( ord_less @ int @ ( power_power @ int @ B @ W ) @ X ) ) ) ).

% of_int_less_of_int_power_cancel_iff
thf(fact_58_of__int__less__0__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less @ A @ ( ring_1_of_int @ A @ Z ) @ ( zero_zero @ A ) )
          = ( ord_less @ int @ Z @ ( zero_zero @ int ) ) ) ) ).

% of_int_less_0_iff
thf(fact_59_of__int__0__less__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( ring_1_of_int @ A @ Z ) )
          = ( ord_less @ int @ ( zero_zero @ int ) @ Z ) ) ) ).

% of_int_0_less_iff
thf(fact_60_abs__minus__commute,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A,B: A] :
          ( ( abs_abs @ A @ ( minus_minus @ A @ A2 @ B ) )
          = ( abs_abs @ A @ ( minus_minus @ A @ B @ A2 ) ) ) ) ).

% abs_minus_commute
thf(fact_61_cancel__ab__semigroup__add__class_Odiff__right__commute,axiom,
    ! [A: $tType] :
      ( ( cancel146912293up_add @ A )
     => ! [A2: A,C2: A,B: A] :
          ( ( minus_minus @ A @ ( minus_minus @ A @ A2 @ C2 ) @ B )
          = ( minus_minus @ A @ ( minus_minus @ A @ A2 @ B ) @ C2 ) ) ) ).

% cancel_ab_semigroup_add_class.diff_right_commute
thf(fact_62_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A2: A,B: A,C2: A,D: A] :
          ( ( ( minus_minus @ A @ A2 @ B )
            = ( minus_minus @ A @ C2 @ D ) )
         => ( ( A2 = B )
            = ( C2 = D ) ) ) ) ).

% diff_eq_diff_eq
thf(fact_63_liouville_Oapprox__int,axiom,
    ! [X: real,P: nat > int,Q: nat > int,N: nat] :
      ( ( liouvi603386861uville @ X @ P @ Q )
     => ( ord_less @ real @ ( abs_abs @ real @ ( minus_minus @ real @ X @ ( divide_divide @ real @ ( ring_1_of_int @ real @ ( P @ N ) ) @ ( ring_1_of_int @ real @ ( Q @ N ) ) ) ) ) @ ( divide_divide @ real @ ( one_one @ real ) @ ( power_power @ real @ ( ring_1_of_int @ real @ ( Q @ N ) ) @ N ) ) ) ) ).

% liouville.approx_int
thf(fact_64_abs__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( idom_abs_sgn @ A )
     => ! [A2: A] :
          ( ( ( abs_abs @ A @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% abs_eq_0_iff
thf(fact_65_abs__one,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ( ( abs_abs @ A @ ( one_one @ A ) )
        = ( one_one @ A ) ) ) ).

% abs_one
thf(fact_66_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ( ( ^ [Y: A,Z2: A] : ( Y = Z2 ) )
        = ( ^ [A4: A,B2: A] :
              ( ( minus_minus @ A @ A4 @ B2 )
              = ( zero_zero @ A ) ) ) ) ) ).

% eq_iff_diff_eq_0
thf(fact_67_diff__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A2: A,B: A,C2: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ord_less @ A @ ( minus_minus @ A @ A2 @ C2 ) @ ( minus_minus @ A @ B @ C2 ) ) ) ) ).

% diff_strict_right_mono
thf(fact_68_diff__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [B: A,A2: A,C2: A] :
          ( ( ord_less @ A @ B @ A2 )
         => ( ord_less @ A @ ( minus_minus @ A @ C2 @ A2 ) @ ( minus_minus @ A @ C2 @ B ) ) ) ) ).

% diff_strict_left_mono
thf(fact_69_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A2: A,B: A,C2: A,D: A] :
          ( ( ( minus_minus @ A @ A2 @ B )
            = ( minus_minus @ A @ C2 @ D ) )
         => ( ( ord_less @ A @ A2 @ B )
            = ( ord_less @ A @ C2 @ D ) ) ) ) ).

% diff_eq_diff_less
thf(fact_70_diff__strict__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A2: A,B: A,D: A,C2: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ord_less @ A @ D @ C2 )
           => ( ord_less @ A @ ( minus_minus @ A @ A2 @ C2 ) @ ( minus_minus @ A @ B @ D ) ) ) ) ) ).

% diff_strict_mono
thf(fact_71_of__int__lessD,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [N: int,X: A] :
          ( ( ord_less @ A @ ( abs_abs @ A @ ( ring_1_of_int @ A @ N ) ) @ X )
         => ( ( N
              = ( zero_zero @ int ) )
            | ( ord_less @ A @ ( one_one @ A ) @ X ) ) ) ) ).

% of_int_lessD
thf(fact_72_less__int__code_I1_J,axiom,
    ~ ( ord_less @ int @ ( zero_zero @ int ) @ ( zero_zero @ int ) ) ).

% less_int_code(1)
thf(fact_73_liouville_Ointro,axiom,
    ! [X: real,P: nat > int,Q: nat > int] :
      ( ! [N2: nat] : ( ord_less @ real @ ( zero_zero @ real ) @ ( abs_abs @ real @ ( minus_minus @ real @ X @ ( divide_divide @ real @ ( ring_1_of_int @ real @ ( P @ N2 ) ) @ ( ring_1_of_int @ real @ ( Q @ N2 ) ) ) ) ) )
     => ( ! [N2: nat] : ( ord_less @ int @ ( one_one @ int ) @ ( Q @ N2 ) )
       => ( ! [N2: nat] : ( ord_less @ real @ ( abs_abs @ real @ ( minus_minus @ real @ X @ ( divide_divide @ real @ ( ring_1_of_int @ real @ ( P @ N2 ) ) @ ( ring_1_of_int @ real @ ( Q @ N2 ) ) ) ) ) @ ( divide_divide @ real @ ( one_one @ real ) @ ( power_power @ real @ ( ring_1_of_int @ real @ ( Q @ N2 ) ) @ N2 ) ) )
         => ( liouvi603386861uville @ X @ P @ Q ) ) ) ) ).

% liouville.intro
thf(fact_74_liouville__def,axiom,
    ( liouvi603386861uville
    = ( ^ [X2: real,P4: nat > int,Q4: nat > int] :
          ( ! [N3: nat] : ( ord_less @ real @ ( zero_zero @ real ) @ ( abs_abs @ real @ ( minus_minus @ real @ X2 @ ( divide_divide @ real @ ( ring_1_of_int @ real @ ( P4 @ N3 ) ) @ ( ring_1_of_int @ real @ ( Q4 @ N3 ) ) ) ) ) )
          & ! [N3: nat] : ( ord_less @ int @ ( one_one @ int ) @ ( Q4 @ N3 ) )
          & ! [N3: nat] : ( ord_less @ real @ ( abs_abs @ real @ ( minus_minus @ real @ X2 @ ( divide_divide @ real @ ( ring_1_of_int @ real @ ( P4 @ N3 ) ) @ ( ring_1_of_int @ real @ ( Q4 @ N3 ) ) ) ) ) @ ( divide_divide @ real @ ( one_one @ real ) @ ( power_power @ real @ ( ring_1_of_int @ real @ ( Q4 @ N3 ) ) @ N3 ) ) ) ) ) ) ).

% liouville_def
thf(fact_75_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [X: A] :
          ( ( ( zero_zero @ A )
            = X )
          = ( X
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_76_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [X: A,Y2: A] :
          ( ( X != Y2 )
         => ( ~ ( ord_less @ A @ X @ Y2 )
           => ( ord_less @ A @ Y2 @ X ) ) ) ) ).

% linorder_neqE_linordered_idom
thf(fact_77_abs__not__less__zero,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A] :
          ~ ( ord_less @ A @ ( abs_abs @ A @ A2 ) @ ( zero_zero @ A ) ) ) ).

% abs_not_less_zero
thf(fact_78_abs__of__pos,axiom,
    ! [A: $tType] :
      ( ( ordere142940540dd_abs @ A )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( abs_abs @ A @ A2 )
            = A2 ) ) ) ).

% abs_of_pos
thf(fact_79_one__reorient,axiom,
    ! [A: $tType] :
      ( ( one @ A )
     => ! [X: A] :
          ( ( ( one_one @ A )
            = X )
          = ( X
            = ( one_one @ A ) ) ) ) ).

% one_reorient
thf(fact_80_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ( ( ord_less @ A )
        = ( ^ [A4: A,B2: A] : ( ord_less @ A @ ( minus_minus @ A @ A4 @ B2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% less_iff_diff_less_0
thf(fact_81_liouville_Oapprox__int__pos,axiom,
    ! [X: real,P: nat > int,Q: nat > int,N: nat] :
      ( ( liouvi603386861uville @ X @ P @ Q )
     => ( ord_less @ real @ ( zero_zero @ real ) @ ( abs_abs @ real @ ( minus_minus @ real @ X @ ( divide_divide @ real @ ( ring_1_of_int @ real @ ( P @ N ) ) @ ( ring_1_of_int @ real @ ( Q @ N ) ) ) ) ) ) ) ).

% liouville.approx_int_pos
thf(fact_82_liouville__irrational__algebraic,axiom,
    ! [X: real] :
      ( ~ ( member @ real @ X @ ( field_char_0_Rats @ real ) )
     => ( ( algebraic @ real @ X )
       => ~ ! [C: real] :
              ( ( ord_less @ real @ ( zero_zero @ real ) @ C )
             => ! [N2: nat] :
                  ~ ! [P2: int,Q2: int] :
                      ( ( ord_less @ int @ ( zero_zero @ int ) @ Q2 )
                     => ( ord_less @ real @ ( divide_divide @ real @ C @ ( power_power @ real @ ( ring_1_of_int @ real @ Q2 ) @ N2 ) ) @ ( abs_abs @ real @ ( minus_minus @ real @ X @ ( divide_divide @ real @ ( ring_1_of_int @ real @ P2 ) @ ( ring_1_of_int @ real @ Q2 ) ) ) ) ) ) ) ) ) ).

% liouville_irrational_algebraic
thf(fact_83_of__int__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z: int] :
          ( ( ord_less @ int @ ( zero_zero @ int ) @ Z )
         => ( ord_less @ A @ ( zero_zero @ A ) @ ( ring_1_of_int @ A @ Z ) ) ) ) ).

% of_int_pos
thf(fact_84_zero__less__iff__neq__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ N )
          = ( N
           != ( zero_zero @ A ) ) ) ) ).

% zero_less_iff_neq_zero
thf(fact_85_gr__implies__not__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [M: A,N: A] :
          ( ( ord_less @ A @ M @ N )
         => ( N
           != ( zero_zero @ A ) ) ) ) ).

% gr_implies_not_zero
thf(fact_86_not__less__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ~ ( ord_less @ A @ N @ ( zero_zero @ A ) ) ) ).

% not_less_zero
thf(fact_87_gr__zeroI,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( N
           != ( zero_zero @ A ) )
         => ( ord_less @ A @ ( zero_zero @ A ) @ N ) ) ) ).

% gr_zeroI
thf(fact_88_less__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ~ ( ord_less @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% less_numeral_extra(3)
thf(fact_89_zero__neq__one,axiom,
    ! [A: $tType] :
      ( ( zero_neq_one @ A )
     => ( ( zero_zero @ A )
       != ( one_one @ A ) ) ) ).

% zero_neq_one
thf(fact_90_less__numeral__extra_I4_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ~ ( ord_less @ A @ ( one_one @ A ) @ ( one_one @ A ) ) ) ).

% less_numeral_extra(4)
thf(fact_91_zero__less__power__abs__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [A2: A,N: nat] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( power_power @ A @ ( abs_abs @ A @ A2 ) @ N ) )
          = ( ( A2
             != ( zero_zero @ A ) )
            | ( N
              = ( zero_zero @ nat ) ) ) ) ) ).

% zero_less_power_abs_iff
thf(fact_92_power__strict__decreasing__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [B: A,M: nat,N: nat] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ B )
         => ( ( ord_less @ A @ B @ ( one_one @ A ) )
           => ( ( ord_less @ A @ ( power_power @ A @ B @ M ) @ ( power_power @ A @ B @ N ) )
              = ( ord_less @ nat @ N @ M ) ) ) ) ) ).

% power_strict_decreasing_iff
thf(fact_93_zero__less__divide__1__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ ( one_one @ A ) @ A2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ A2 ) ) ) ).

% zero_less_divide_1_iff
thf(fact_94_less__divide__eq__1__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less @ A @ ( one_one @ A ) @ ( divide_divide @ A @ B @ A2 ) )
            = ( ord_less @ A @ A2 @ B ) ) ) ) ).

% less_divide_eq_1_pos
thf(fact_95_less__divide__eq__1__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ ( one_one @ A ) @ ( divide_divide @ A @ B @ A2 ) )
            = ( ord_less @ A @ B @ A2 ) ) ) ) ).

% less_divide_eq_1_neg
thf(fact_96_divide__less__eq__1__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less @ A @ ( divide_divide @ A @ B @ A2 ) @ ( one_one @ A ) )
            = ( ord_less @ A @ B @ A2 ) ) ) ) ).

% divide_less_eq_1_pos
thf(fact_97_divide__less__eq__1__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ ( divide_divide @ A @ B @ A2 ) @ ( one_one @ A ) )
            = ( ord_less @ A @ A2 @ B ) ) ) ) ).

% divide_less_eq_1_neg
thf(fact_98_divide__less__0__1__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( divide_divide @ A @ ( one_one @ A ) @ A2 ) @ ( zero_zero @ A ) )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% divide_less_0_1_iff
thf(fact_99_power__strict__increasing__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [B: A,X: nat,Y2: nat] :
          ( ( ord_less @ A @ ( one_one @ A ) @ B )
         => ( ( ord_less @ A @ ( power_power @ A @ B @ X ) @ ( power_power @ A @ B @ Y2 ) )
            = ( ord_less @ nat @ X @ Y2 ) ) ) ) ).

% power_strict_increasing_iff
thf(fact_100_power__inject__exp,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,M: nat,N: nat] :
          ( ( ord_less @ A @ ( one_one @ A ) @ A2 )
         => ( ( ( power_power @ A @ A2 @ M )
              = ( power_power @ A @ A2 @ N ) )
            = ( M = N ) ) ) ) ).

% power_inject_exp
thf(fact_101_power__one__right,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A )
     => ! [A2: A] :
          ( ( power_power @ A @ A2 @ ( one_one @ nat ) )
          = A2 ) ) ).

% power_one_right
thf(fact_102_divide__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [A2: A,B: A] :
          ( ( ( divide_divide @ A @ A2 @ B )
            = ( zero_zero @ A ) )
          = ( ( A2
              = ( zero_zero @ A ) )
            | ( B
              = ( zero_zero @ A ) ) ) ) ) ).

% divide_eq_0_iff
thf(fact_103_divide__cancel__left,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [C2: A,A2: A,B: A] :
          ( ( ( divide_divide @ A @ C2 @ A2 )
            = ( divide_divide @ A @ C2 @ B ) )
          = ( ( C2
              = ( zero_zero @ A ) )
            | ( A2 = B ) ) ) ) ).

% divide_cancel_left
thf(fact_104_divide__cancel__right,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [A2: A,C2: A,B: A] :
          ( ( ( divide_divide @ A @ A2 @ C2 )
            = ( divide_divide @ A @ B @ C2 ) )
          = ( ( C2
              = ( zero_zero @ A ) )
            | ( A2 = B ) ) ) ) ).

% divide_cancel_right
thf(fact_105_division__ring__divide__zero,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A2: A] :
          ( ( divide_divide @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% division_ring_divide_zero
thf(fact_106_power__one,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A )
     => ! [N: nat] :
          ( ( power_power @ A @ ( one_one @ A ) @ N )
          = ( one_one @ A ) ) ) ).

% power_one
thf(fact_107_nat__zero__less__power__iff,axiom,
    ! [X: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( power_power @ nat @ X @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ X )
        | ( N
          = ( zero_zero @ nat ) ) ) ) ).

% nat_zero_less_power_iff
thf(fact_108_abs__divide,axiom,
    ! [A: $tType] :
      ( ( field_abs_sgn @ A )
     => ! [A2: A,B: A] :
          ( ( abs_abs @ A @ ( divide_divide @ A @ A2 @ B ) )
          = ( divide_divide @ A @ ( abs_abs @ A @ A2 ) @ ( abs_abs @ A @ B ) ) ) ) ).

% abs_divide
thf(fact_109_divide__eq__1__iff,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [A2: A,B: A] :
          ( ( ( divide_divide @ A @ A2 @ B )
            = ( one_one @ A ) )
          = ( ( B
             != ( zero_zero @ A ) )
            & ( A2 = B ) ) ) ) ).

% divide_eq_1_iff
thf(fact_110_one__eq__divide__iff,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [A2: A,B: A] :
          ( ( ( one_one @ A )
            = ( divide_divide @ A @ A2 @ B ) )
          = ( ( B
             != ( zero_zero @ A ) )
            & ( A2 = B ) ) ) ) ).

% one_eq_divide_iff
thf(fact_111_divide__self,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ A2 @ A2 )
            = ( one_one @ A ) ) ) ) ).

% divide_self
thf(fact_112_divide__self__if,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A2: A] :
          ( ( ( A2
              = ( zero_zero @ A ) )
           => ( ( divide_divide @ A @ A2 @ A2 )
              = ( zero_zero @ A ) ) )
          & ( ( A2
             != ( zero_zero @ A ) )
           => ( ( divide_divide @ A @ A2 @ A2 )
              = ( one_one @ A ) ) ) ) ) ).

% divide_self_if
thf(fact_113_divide__eq__eq__1,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [B: A,A2: A] :
          ( ( ( divide_divide @ A @ B @ A2 )
            = ( one_one @ A ) )
          = ( ( A2
             != ( zero_zero @ A ) )
            & ( A2 = B ) ) ) ) ).

% divide_eq_eq_1
thf(fact_114_eq__divide__eq__1,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [B: A,A2: A] :
          ( ( ( one_one @ A )
            = ( divide_divide @ A @ B @ A2 ) )
          = ( ( A2
             != ( zero_zero @ A ) )
            & ( A2 = B ) ) ) ) ).

% eq_divide_eq_1
thf(fact_115_one__divide__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A] :
          ( ( ( divide_divide @ A @ ( one_one @ A ) @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% one_divide_eq_0_iff
thf(fact_116_zero__eq__1__divide__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A] :
          ( ( ( zero_zero @ A )
            = ( divide_divide @ A @ ( one_one @ A ) @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% zero_eq_1_divide_iff
thf(fact_117_power__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiri134348788visors @ A )
     => ! [A2: A,N: nat] :
          ( ( ( power_power @ A @ A2 @ N )
            = ( zero_zero @ A ) )
          = ( ( A2
              = ( zero_zero @ A ) )
            & ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ) ).

% power_eq_0_iff
thf(fact_118_zabs__less__one__iff,axiom,
    ! [Z: int] :
      ( ( ord_less @ int @ ( abs_abs @ int @ Z ) @ ( one_one @ int ) )
      = ( Z
        = ( zero_zero @ int ) ) ) ).

% zabs_less_one_iff
thf(fact_119_nat__power__less__imp__less,axiom,
    ! [I: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ I )
     => ( ( ord_less @ nat @ ( power_power @ nat @ I @ M ) @ ( power_power @ nat @ I @ N ) )
       => ( ord_less @ nat @ M @ N ) ) ) ).

% nat_power_less_imp_less
thf(fact_120_minus__int__code_I1_J,axiom,
    ! [K: int] :
      ( ( minus_minus @ int @ K @ ( zero_zero @ int ) )
      = K ) ).

% minus_int_code(1)
thf(fact_121_int__less__induct,axiom,
    ! [I: int,K: int,P3: int > $o] :
      ( ( ord_less @ int @ I @ K )
     => ( ( P3 @ ( minus_minus @ int @ K @ ( one_one @ int ) ) )
       => ( ! [I2: int] :
              ( ( ord_less @ int @ I2 @ K )
             => ( ( P3 @ I2 )
               => ( P3 @ ( minus_minus @ int @ I2 @ ( one_one @ int ) ) ) ) )
         => ( P3 @ I ) ) ) ) ).

% int_less_induct
thf(fact_122_linordered__field__no__lb,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X4: A] :
        ? [Y3: A] : ( ord_less @ A @ Y3 @ X4 ) ) ).

% linordered_field_no_lb
thf(fact_123_linordered__field__no__ub,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X4: A] :
        ? [X_1: A] : ( ord_less @ A @ X4 @ X_1 ) ) ).

% linordered_field_no_ub
thf(fact_124_power__not__zero,axiom,
    ! [A: $tType] :
      ( ( semiri134348788visors @ A )
     => ! [A2: A,N: nat] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( power_power @ A @ A2 @ N )
           != ( zero_zero @ A ) ) ) ) ).

% power_not_zero
thf(fact_125_zero__power,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A )
     => ! [N: nat] :
          ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
         => ( ( power_power @ A @ ( zero_zero @ A ) @ N )
            = ( zero_zero @ A ) ) ) ) ).

% zero_power
thf(fact_126_diff__divide__distrib,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A2: A,B: A,C2: A] :
          ( ( divide_divide @ A @ ( minus_minus @ A @ A2 @ B ) @ C2 )
          = ( minus_minus @ A @ ( divide_divide @ A @ A2 @ C2 ) @ ( divide_divide @ A @ B @ C2 ) ) ) ) ).

% diff_divide_distrib
thf(fact_127_power__0,axiom,
    ! [A: $tType] :
      ( ( power @ A )
     => ! [A2: A] :
          ( ( power_power @ A @ A2 @ ( zero_zero @ nat ) )
          = ( one_one @ A ) ) ) ).

% power_0
thf(fact_128_power__divide,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [A2: A,B: A,N: nat] :
          ( ( power_power @ A @ ( divide_divide @ A @ A2 @ B ) @ N )
          = ( divide_divide @ A @ ( power_power @ A @ A2 @ N ) @ ( power_power @ A @ B @ N ) ) ) ) ).

% power_divide
thf(fact_129_power__abs,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [A2: A,N: nat] :
          ( ( abs_abs @ A @ ( power_power @ A @ A2 @ N ) )
          = ( power_power @ A @ ( abs_abs @ A @ A2 ) @ N ) ) ) ).

% power_abs
thf(fact_130_divide__neg__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less @ A @ X @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ Y2 @ ( zero_zero @ A ) )
           => ( ord_less @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ X @ Y2 ) ) ) ) ) ).

% divide_neg_neg
thf(fact_131_divide__neg__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less @ A @ X @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ Y2 )
           => ( ord_less @ A @ ( divide_divide @ A @ X @ Y2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% divide_neg_pos
thf(fact_132_divide__pos__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ X )
         => ( ( ord_less @ A @ Y2 @ ( zero_zero @ A ) )
           => ( ord_less @ A @ ( divide_divide @ A @ X @ Y2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% divide_pos_neg
thf(fact_133_divide__pos__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X: A,Y2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ X )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ Y2 )
           => ( ord_less @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ X @ Y2 ) ) ) ) ) ).

% divide_pos_pos
thf(fact_134_divide__less__0__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ ( divide_divide @ A @ A2 @ B ) @ ( zero_zero @ A ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less @ A @ B @ ( zero_zero @ A ) ) )
            | ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less @ A @ ( zero_zero @ A ) @ B ) ) ) ) ) ).

% divide_less_0_iff
thf(fact_135_divide__less__cancel,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,C2: A,B: A] :
          ( ( ord_less @ A @ ( divide_divide @ A @ A2 @ C2 ) @ ( divide_divide @ A @ B @ C2 ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ C2 )
             => ( ord_less @ A @ A2 @ B ) )
            & ( ( ord_less @ A @ C2 @ ( zero_zero @ A ) )
             => ( ord_less @ A @ B @ A2 ) )
            & ( C2
             != ( zero_zero @ A ) ) ) ) ) ).

% divide_less_cancel
thf(fact_136_zero__less__divide__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( divide_divide @ A @ A2 @ B ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less @ A @ ( zero_zero @ A ) @ B ) )
            | ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less @ A @ B @ ( zero_zero @ A ) ) ) ) ) ) ).

% zero_less_divide_iff
thf(fact_137_divide__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A2: A,B: A,C2: A] :
          ( ( ord_less @ A @ A2 @ B )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ C2 )
           => ( ord_less @ A @ ( divide_divide @ A @ A2 @ C2 ) @ ( divide_divide @ A @ B @ C2 ) ) ) ) ) ).

% divide_strict_right_mono
thf(fact_138_divide__strict__right__mono__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [B: A,A2: A,C2: A] :
          ( ( ord_less @ A @ B @ A2 )
         => ( ( ord_less @ A @ C2 @ ( zero_zero @ A ) )
           => ( ord_less @ A @ ( divide_divide @ A @ A2 @ C2 ) @ ( divide_divide @ A @ B @ C2 ) ) ) ) ) ).

% divide_strict_right_mono_neg
thf(fact_139_zero__less__power,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,N: nat] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ord_less @ A @ ( zero_zero @ A ) @ ( power_power @ A @ A2 @ N ) ) ) ) ).

% zero_less_power
thf(fact_140_right__inverse__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [B: A,A2: A] :
          ( ( B
           != ( zero_zero @ A ) )
         => ( ( ( divide_divide @ A @ A2 @ B )
              = ( one_one @ A ) )
            = ( A2 = B ) ) ) ) ).

% right_inverse_eq
thf(fact_141_power__0__left,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A )
     => ! [N: nat] :
          ( ( ( N
              = ( zero_zero @ nat ) )
           => ( ( power_power @ A @ ( zero_zero @ A ) @ N )
              = ( one_one @ A ) ) )
          & ( ( N
             != ( zero_zero @ nat ) )
           => ( ( power_power @ A @ ( zero_zero @ A ) @ N )
              = ( zero_zero @ A ) ) ) ) ) ).

% power_0_left
thf(fact_142_power__less__imp__less__exp,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,M: nat,N: nat] :
          ( ( ord_less @ A @ ( one_one @ A ) @ A2 )
         => ( ( ord_less @ A @ ( power_power @ A @ A2 @ M ) @ ( power_power @ A @ A2 @ N ) )
           => ( ord_less @ nat @ M @ N ) ) ) ) ).

% power_less_imp_less_exp
thf(fact_143_power__strict__increasing,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [N: nat,N4: nat,A2: A] :
          ( ( ord_less @ nat @ N @ N4 )
         => ( ( ord_less @ A @ ( one_one @ A ) @ A2 )
           => ( ord_less @ A @ ( power_power @ A @ A2 @ N ) @ ( power_power @ A @ A2 @ N4 ) ) ) ) ) ).

% power_strict_increasing
thf(fact_144_one__less__power,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [A2: A,N: nat] :
          ( ( ord_less @ A @ ( one_one @ A ) @ A2 )
         => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
           => ( ord_less @ A @ ( one_one @ A ) @ ( power_power @ A @ A2 @ N ) ) ) ) ) ).

% one_less_power
thf(fact_145_power__one__over,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A2: A,N: nat] :
          ( ( power_power @ A @ ( divide_divide @ A @ ( one_one @ A ) @ A2 ) @ N )
          = ( divide_divide @ A @ ( one_one @ A ) @ ( power_power @ A @ A2 @ N ) ) ) ) ).

% power_one_over
thf(fact_146_nonzero__abs__divide,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [B: A,A2: A] :
          ( ( B
           != ( zero_zero @ A ) )
         => ( ( abs_abs @ A @ ( divide_divide @ A @ A2 @ B ) )
            = ( divide_divide @ A @ ( abs_abs @ A @ A2 ) @ ( abs_abs @ A @ B ) ) ) ) ) ).

% nonzero_abs_divide
thf(fact_147_divide__less__eq__1,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less @ A @ ( divide_divide @ A @ B @ A2 ) @ ( one_one @ A ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less @ A @ B @ A2 ) )
            | ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less @ A @ A2 @ B ) )
            | ( A2
              = ( zero_zero @ A ) ) ) ) ) ).

% divide_less_eq_1
thf(fact_148_less__divide__eq__1,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [B: A,A2: A] :
          ( ( ord_less @ A @ ( one_one @ A ) @ ( divide_divide @ A @ B @ A2 ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less @ A @ A2 @ B ) )
            | ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less @ A @ B @ A2 ) ) ) ) ) ).

% less_divide_eq_1
thf(fact_149_power__strict__decreasing,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A )
     => ! [N: nat,N4: nat,A2: A] :
          ( ( ord_less @ nat @ N @ N4 )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
           => ( ( ord_less @ A @ A2 @ ( one_one @ A ) )
             => ( ord_less @ A @ ( power_power @ A @ A2 @ N4 ) @ ( power_power @ A @ A2 @ N ) ) ) ) ) ) ).

% power_strict_decreasing
thf(fact_150_abs__div__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [Y2: A,X: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ Y2 )
         => ( ( divide_divide @ A @ ( abs_abs @ A @ X ) @ Y2 )
            = ( abs_abs @ A @ ( divide_divide @ A @ X @ Y2 ) ) ) ) ) ).

% abs_div_pos
thf(fact_151_Rats__abs__iff,axiom,
    ! [X: real] :
      ( ( member @ real @ ( abs_abs @ real @ X ) @ ( field_char_0_Rats @ real ) )
      = ( member @ real @ X @ ( field_char_0_Rats @ real ) ) ) ).

% Rats_abs_iff
thf(fact_152_Liouville__Numbers__Misc_ORats__cases_H,axiom,
    ! [X: real] :
      ( ( member @ real @ X @ ( field_char_0_Rats @ real ) )
     => ~ ! [P5: int,Q5: int] :
            ( ( ord_less @ int @ ( zero_zero @ int ) @ Q5 )
           => ( X
             != ( divide_divide @ real @ ( ring_1_of_int @ real @ P5 ) @ ( ring_1_of_int @ real @ Q5 ) ) ) ) ) ).

% Liouville_Numbers_Misc.Rats_cases'
thf(fact_153_realpow__pos__nth,axiom,
    ! [N: nat,A2: real] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ A2 )
       => ? [R: real] :
            ( ( ord_less @ real @ ( zero_zero @ real ) @ R )
            & ( ( power_power @ real @ R @ N )
              = A2 ) ) ) ) ).

% realpow_pos_nth
thf(fact_154_realpow__pos__nth__unique,axiom,
    ! [N: nat,A2: real] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ A2 )
       => ? [X3: real] :
            ( ( ord_less @ real @ ( zero_zero @ real ) @ X3 )
            & ( ( power_power @ real @ X3 @ N )
              = A2 )
            & ! [Y4: real] :
                ( ( ( ord_less @ real @ ( zero_zero @ real ) @ Y4 )
                  & ( ( power_power @ real @ Y4 @ N )
                    = A2 ) )
               => ( Y4 = X3 ) ) ) ) ) ).

% realpow_pos_nth_unique
thf(fact_155_less__one,axiom,
    ! [N: nat] :
      ( ( ord_less @ nat @ N @ ( one_one @ nat ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% less_one
thf(fact_156_diff__self__eq__0,axiom,
    ! [M: nat] :
      ( ( minus_minus @ nat @ M @ M )
      = ( zero_zero @ nat ) ) ).

% diff_self_eq_0
thf(fact_157_diff__0__eq__0,axiom,
    ! [N: nat] :
      ( ( minus_minus @ nat @ ( zero_zero @ nat ) @ N )
      = ( zero_zero @ nat ) ) ).

% diff_0_eq_0
thf(fact_158_bot__nat__0_Onot__eq__extremum,axiom,
    ! [A2: nat] :
      ( ( A2
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ A2 ) ) ).

% bot_nat_0.not_eq_extremum
thf(fact_159_less__nat__zero__code,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% less_nat_zero_code
thf(fact_160_zero__less__diff,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( minus_minus @ nat @ N @ M ) )
      = ( ord_less @ nat @ M @ N ) ) ).

% zero_less_diff
thf(fact_161_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% neq0_conv
thf(fact_162_measure__induct__rule,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( wellorder @ B3 )
     => ! [F: A > B3,P3: A > $o,A2: A] :
          ( ! [X3: A] :
              ( ! [Y4: A] :
                  ( ( ord_less @ B3 @ ( F @ Y4 ) @ ( F @ X3 ) )
                 => ( P3 @ Y4 ) )
             => ( P3 @ X3 ) )
         => ( P3 @ A2 ) ) ) ).

% measure_induct_rule
thf(fact_163_measure__induct,axiom,
    ! [B3: $tType,A: $tType] :
      ( ( wellorder @ B3 )
     => ! [F: A > B3,P3: A > $o,A2: A] :
          ( ! [X3: A] :
              ( ! [Y4: A] :
                  ( ( ord_less @ B3 @ ( F @ Y4 ) @ ( F @ X3 ) )
                 => ( P3 @ Y4 ) )
             => ( P3 @ X3 ) )
         => ( P3 @ A2 ) ) ) ).

% measure_induct
thf(fact_164_minus__nat_Odiff__0,axiom,
    ! [M: nat] :
      ( ( minus_minus @ nat @ M @ ( zero_zero @ nat ) )
      = M ) ).

% minus_nat.diff_0
thf(fact_165_diffs0__imp__equal,axiom,
    ! [M: nat,N: nat] :
      ( ( ( minus_minus @ nat @ M @ N )
        = ( zero_zero @ nat ) )
     => ( ( ( minus_minus @ nat @ N @ M )
          = ( zero_zero @ nat ) )
       => ( M = N ) ) ) ).

% diffs0_imp_equal
thf(fact_166_infinite__descent__measure,axiom,
    ! [A: $tType,P3: A > $o,V: A > nat,X: A] :
      ( ! [X3: A] :
          ( ~ ( P3 @ X3 )
         => ? [Y4: A] :
              ( ( ord_less @ nat @ ( V @ Y4 ) @ ( V @ X3 ) )
              & ~ ( P3 @ Y4 ) ) )
     => ( P3 @ X ) ) ).

% infinite_descent_measure
thf(fact_167_less__imp__diff__less,axiom,
    ! [J: nat,K: nat,N: nat] :
      ( ( ord_less @ nat @ J @ K )
     => ( ord_less @ nat @ ( minus_minus @ nat @ J @ N ) @ K ) ) ).

% less_imp_diff_less
thf(fact_168_linorder__neqE__nat,axiom,
    ! [X: nat,Y2: nat] :
      ( ( X != Y2 )
     => ( ~ ( ord_less @ nat @ X @ Y2 )
       => ( ord_less @ nat @ Y2 @ X ) ) ) ).

% linorder_neqE_nat
thf(fact_169_infinite__descent,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ~ ( P3 @ N2 )
         => ? [M2: nat] :
              ( ( ord_less @ nat @ M2 @ N2 )
              & ~ ( P3 @ M2 ) ) )
     => ( P3 @ N ) ) ).

% infinite_descent
thf(fact_170_nat__less__induct,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ! [M2: nat] :
              ( ( ord_less @ nat @ M2 @ N2 )
             => ( P3 @ M2 ) )
         => ( P3 @ N2 ) )
     => ( P3 @ N ) ) ).

% nat_less_induct
thf(fact_171_less__irrefl__nat,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_irrefl_nat
thf(fact_172_diff__less__mono2,axiom,
    ! [M: nat,N: nat,L: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ( ord_less @ nat @ M @ L )
       => ( ord_less @ nat @ ( minus_minus @ nat @ L @ N ) @ ( minus_minus @ nat @ L @ M ) ) ) ) ).

% diff_less_mono2
thf(fact_173_less__not__refl3,axiom,
    ! [S: nat,T: nat] :
      ( ( ord_less @ nat @ S @ T )
     => ( S != T ) ) ).

% less_not_refl3
thf(fact_174_less__not__refl2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ N @ M )
     => ( M != N ) ) ).

% less_not_refl2
thf(fact_175_less__not__refl,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_not_refl
thf(fact_176_nat__neq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( M != N )
      = ( ( ord_less @ nat @ M @ N )
        | ( ord_less @ nat @ N @ M ) ) ) ).

% nat_neq_iff
thf(fact_177_field__lbound__gt__zero,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [D1: A,D2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ D1 )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ D2 )
           => ? [E: A] :
                ( ( ord_less @ A @ ( zero_zero @ A ) @ E )
                & ( ord_less @ A @ E @ D1 )
                & ( ord_less @ A @ E @ D2 ) ) ) ) ) ).

% field_lbound_gt_zero
thf(fact_178_infinite__descent0__measure,axiom,
    ! [A: $tType,V: A > nat,P3: A > $o,X: A] :
      ( ! [X3: A] :
          ( ( ( V @ X3 )
            = ( zero_zero @ nat ) )
         => ( P3 @ X3 ) )
     => ( ! [X3: A] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( V @ X3 ) )
           => ( ~ ( P3 @ X3 )
             => ? [Y4: A] :
                  ( ( ord_less @ nat @ ( V @ Y4 ) @ ( V @ X3 ) )
                  & ~ ( P3 @ Y4 ) ) ) )
       => ( P3 @ X ) ) ) ).

% infinite_descent0_measure
thf(fact_179_bot__nat__0_Oextremum__strict,axiom,
    ! [A2: nat] :
      ~ ( ord_less @ nat @ A2 @ ( zero_zero @ nat ) ) ).

% bot_nat_0.extremum_strict
thf(fact_180_infinite__descent0,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ( P3 @ ( zero_zero @ nat ) )
     => ( ! [N2: nat] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N2 )
           => ( ~ ( P3 @ N2 )
             => ? [M2: nat] :
                  ( ( ord_less @ nat @ M2 @ N2 )
                  & ~ ( P3 @ M2 ) ) ) )
       => ( P3 @ N ) ) ) ).

% infinite_descent0
thf(fact_181_gr__implies__not0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( N
       != ( zero_zero @ nat ) ) ) ).

% gr_implies_not0
thf(fact_182_less__zeroE,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% less_zeroE
thf(fact_183_not__less0,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% not_less0
thf(fact_184_diff__less,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
     => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
       => ( ord_less @ nat @ ( minus_minus @ nat @ M @ N ) @ M ) ) ) ).

% diff_less
thf(fact_185_not__gr0,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% not_gr0
thf(fact_186_gr0I,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
     => ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% gr0I
thf(fact_187_Rats__dense__in__real,axiom,
    ! [X: real,Y2: real] :
      ( ( ord_less @ real @ X @ Y2 )
     => ? [X3: real] :
          ( ( member @ real @ X3 @ ( field_char_0_Rats @ real ) )
          & ( ord_less @ real @ X @ X3 )
          & ( ord_less @ real @ X3 @ Y2 ) ) ) ).

% Rats_dense_in_real
thf(fact_188_Rats__no__bot__less,axiom,
    ! [X: real] :
    ? [X3: real] :
      ( ( member @ real @ X3 @ ( field_char_0_Rats @ real ) )
      & ( ord_less @ real @ X3 @ X ) ) ).

% Rats_no_bot_less
thf(fact_189_real__arch__pow,axiom,
    ! [X: real,Y2: real] :
      ( ( ord_less @ real @ ( one_one @ real ) @ X )
     => ? [N2: nat] : ( ord_less @ real @ Y2 @ ( power_power @ real @ X @ N2 ) ) ) ).

% real_arch_pow
thf(fact_190_real__arch__pow__inv,axiom,
    ! [Y2: real,X: real] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ Y2 )
     => ( ( ord_less @ real @ X @ ( one_one @ real ) )
       => ? [N2: nat] : ( ord_less @ real @ ( power_power @ real @ X @ N2 ) @ Y2 ) ) ) ).

% real_arch_pow_inv
thf(fact_191_div__less,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ( divide_divide @ nat @ M @ N )
        = ( zero_zero @ nat ) ) ) ).

% div_less
thf(fact_192_bits__div__by__1,axiom,
    ! [A: $tType] :
      ( ( semiring_bits @ A )
     => ! [A2: A] :
          ( ( divide_divide @ A @ A2 @ ( one_one @ A ) )
          = A2 ) ) ).

% bits_div_by_1
thf(fact_193_bits__div__by__0,axiom,
    ! [A: $tType] :
      ( ( semiring_bits @ A )
     => ! [A2: A] :
          ( ( divide_divide @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% bits_div_by_0
thf(fact_194_bits__div__0,axiom,
    ! [A: $tType] :
      ( ( semiring_bits @ A )
     => ! [A2: A] :
          ( ( divide_divide @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% bits_div_0
thf(fact_195_diff__commute,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( minus_minus @ nat @ ( minus_minus @ nat @ I @ J ) @ K )
      = ( minus_minus @ nat @ ( minus_minus @ nat @ I @ K ) @ J ) ) ).

% diff_commute
thf(fact_196_Euclidean__Division_Odiv__eq__0__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ( divide_divide @ nat @ M @ N )
        = ( zero_zero @ nat ) )
      = ( ( ord_less @ nat @ M @ N )
        | ( N
          = ( zero_zero @ nat ) ) ) ) ).

% Euclidean_Division.div_eq_0_iff
thf(fact_197_div__less__dividend,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ ( one_one @ nat ) @ N )
     => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
       => ( ord_less @ nat @ ( divide_divide @ nat @ M @ N ) @ M ) ) ) ).

% div_less_dividend
thf(fact_198_div__eq__dividend__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
     => ( ( ( divide_divide @ nat @ M @ N )
          = M )
        = ( N
          = ( one_one @ nat ) ) ) ) ).

% div_eq_dividend_iff
thf(fact_199_around__zero_Oinduct,axiom,
    ! [P3: int > $o,A0: int] :
      ( ! [I2: int] :
          ( ( ~ ( ord_less @ int @ I2 @ ( zero_zero @ int ) )
           => ( ( I2
               != ( zero_zero @ int ) )
             => ( P3 @ ( minus_minus @ int @ I2 @ ( one_one @ int ) ) ) ) )
         => ( P3 @ I2 ) )
     => ( P3 @ A0 ) ) ).

% around_zero.induct
thf(fact_200_lemma__interval__lt,axiom,
    ! [A2: real,X: real,B: real] :
      ( ( ord_less @ real @ A2 @ X )
     => ( ( ord_less @ real @ X @ B )
       => ? [D3: real] :
            ( ( ord_less @ real @ ( zero_zero @ real ) @ D3 )
            & ! [Y4: real] :
                ( ( ord_less @ real @ ( abs_abs @ real @ ( minus_minus @ real @ X @ Y4 ) ) @ D3 )
               => ( ( ord_less @ real @ A2 @ Y4 )
                  & ( ord_less @ real @ Y4 @ B ) ) ) ) ) ) ).

% lemma_interval_lt
thf(fact_201_int__div__less__self,axiom,
    ! [X: int,K: int] :
      ( ( ord_less @ int @ ( zero_zero @ int ) @ X )
     => ( ( ord_less @ int @ ( one_one @ int ) @ K )
       => ( ord_less @ int @ ( divide_divide @ int @ X @ K ) @ X ) ) ) ).

% int_div_less_self
thf(fact_202__092_060open_0621_A_P_Areal__of__int_A_Iq_Am_J_A_094_Am_A_061_A1_A_P_Areal__of__int_A_Iq_Am_J_A_094_Ar_A_K_A_I1_A_P_Areal__of__int_A_Iq_Am_J_A_094_An_J_092_060close_062,axiom,
    ( ( divide_divide @ real @ ( one_one @ real ) @ ( power_power @ real @ ( ring_1_of_int @ real @ ( q @ m ) ) @ m ) )
    = ( times_times @ real @ ( divide_divide @ real @ ( one_one @ real ) @ ( power_power @ real @ ( ring_1_of_int @ real @ ( q @ m ) ) @ r ) ) @ ( divide_divide @ real @ ( one_one @ real ) @ ( power_power @ real @ ( ring_1_of_int @ real @ ( q @ m ) ) @ n ) ) ) ) ).

% \<open>1 / real_of_int (q m) ^ m = 1 / real_of_int (q m) ^ r * (1 / real_of_int (q m) ^ n)\<close>
thf(fact_203_mult__cancel__right,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A )
     => ! [A2: A,C2: A,B: A] :
          ( ( ( times_times @ A @ A2 @ C2 )
            = ( times_times @ A @ B @ C2 ) )
          = ( ( C2
              = ( zero_zero @ A ) )
            | ( A2 = B ) ) ) ) ).

% mult_cancel_right
thf(fact_204_mult__cancel__left,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A )
     => ! [C2: A,A2: A,B: A] :
          ( ( ( times_times @ A @ C2 @ A2 )
            = ( times_times @ A @ C2 @ B ) )
          = ( ( C2
              = ( zero_zero @ A ) )
            | ( A2 = B ) ) ) ) ).

% mult_cancel_left
thf(fact_205_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A )
     => ! [A2: A,B: A] :
          ( ( ( times_times @ A @ A2 @ B )
            = ( zero_zero @ A ) )
          = ( ( A2
              = ( zero_zero @ A ) )
            | ( B
              = ( zero_zero @ A ) ) ) ) ) ).

% mult_eq_0_iff
thf(fact_206_mult__zero__right,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% mult_zero_right
thf(fact_207_mult__zero__left,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A )
     => ! [A2: A] :
          ( ( times_times @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% mult_zero_left
thf(fact_208_mult_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( one_one @ A ) )
          = A2 ) ) ).

% mult.right_neutral
thf(fact_209_mult_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A )
     => ! [A2: A] :
          ( ( times_times @ A @ ( one_one @ A ) @ A2 )
          = A2 ) ) ).

% mult.left_neutral
thf(fact_210_times__divide__eq__left,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [B: A,C2: A,A2: A] :
          ( ( times_times @ A @ ( divide_divide @ A @ B @ C2 ) @ A2 )
          = ( divide_divide @ A @ ( times_times @ A @ B @ A2 ) @ C2 ) ) ) ).

% times_divide_eq_left
thf(fact_211_divide__divide__eq__left,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [A2: A,B: A,C2: A] :
          ( ( divide_divide @ A @ ( divide_divide @ A @ A2 @ B ) @ C2 )
          = ( divide_divide @ A @ A2 @ ( times_times @ A @ B @ C2 ) ) ) ) ).

% divide_divide_eq_left
thf(fact_212_divide__divide__eq__right,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [A2: A,B: A,C2: A] :
          ( ( divide_divide @ A @ A2 @ ( divide_divide @ A @ B @ C2 ) )
          = ( divide_divide @ A @ ( times_times @ A @ A2 @ C2 ) @ B ) ) ) ).

% divide_divide_eq_right
thf(fact_213_times__divide__eq__right,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A2: A,B: A,C2: A] :
          ( ( times_times @ A @ A2 @ ( divide_divide @ A @ B @ C2 ) )
          = ( divide_divide @ A @ ( times_times @ A @ A2 @ B ) @ C2 ) ) ) ).

% times_divide_eq_right
thf(fact_214_abs__mult__self__eq,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [A2: A] :
          ( ( times_times @ A @ ( abs_abs @ A @ A2 ) @ ( abs_abs @ A @ A2 ) )
          = ( times_times @ A @ A2 @ A2 ) ) ) ).

% abs_mult_self_eq
thf(fact_215_of__int__mult,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ! [W: int,Z: int] :
          ( ( ring_1_of_int @ A @ ( times_times @ int @ W @ Z ) )
          = ( times_times @ A @ ( ring_1_of_int @ A @ W ) @ ( ring_1_of_int @ A @ Z ) ) ) ) ).

% of_int_mult
thf(fact_216_real__divide__square__eq,axiom,
    ! [R2: real,A2: real] :
      ( ( divide_divide @ real @ ( times_times @ real @ R2 @ A2 ) @ ( times_times @ real @ R2 @ R2 ) )
      = ( divide_divide @ real @ A2 @ R2 ) ) ).

% real_divide_square_eq
thf(fact_217_mult__cancel__left1,axiom,
    ! [A: $tType] :
      ( ( ring_11004092258visors @ A )
     => ! [C2: A,B: A] :
          ( ( C2
            = ( times_times @ A @ C2 @ B ) )
          = ( ( C2
              = ( zero_zero @ A ) )
            | ( B
              = ( one_one @ A ) ) ) ) ) ).

% mult_cancel_left1
thf(fact_218_mult__cancel__left2,axiom,
    ! [A: $tType] :
      ( ( ring_11004092258visors @ A )
     => ! [C2: A,A2: A] :
          ( ( ( times_times @ A @ C2 @ A2 )
            = C2 )
          = ( ( C2
              = ( zero_zero @ A ) )
            | ( A2
              = ( one_one @ A ) ) ) ) ) ).

% mult_cancel_left2
thf(fact_219_mult__cancel__right1,axiom,
    ! [A: $tType] :
      ( ( ring_11004092258visors @ A )
     => ! [C2: A,B: A] :
          ( ( C2
            = ( times_times @ A @ B @ C2 ) )
          = ( ( C2
              = ( zero_zero @ A ) )
            | ( B
              = ( one_one @ A ) ) ) ) ) ).

% mult_cancel_right1
thf(fact_220_mult__cancel__right2,axiom,
    ! [A: $tType] :
      ( ( ring_11004092258visors @ A )
     => ! [A2: A,C2: A] :
          ( ( ( times_times @ A @ A2 @ C2 )
            = C2 )
          = ( ( C2
              = ( zero_zero @ A ) )
            | ( A2
              = ( one_one @ A ) ) ) ) ) ).

% mult_cancel_right2
thf(fact_221_div__mult__mult1__if,axiom,
    ! [A: $tType] :
      ( ( euclid191655569cancel @ A )
     => ! [C2: A,A2: A,B: A] :
          ( ( ( C2
              = ( zero_zero @ A ) )
           => ( ( divide_divide @ A @ ( times_times @ A @ C2 @ A2 ) @ ( times_times @ A @ C2 @ B ) )
              = ( zero_zero @ A ) ) )
          & ( ( C2
             != ( zero_zero @ A ) )
           => ( ( divide_divide @ A @ ( times_times @ A @ C2 @ A2 ) @ ( times_times @ A @ C2 @ B ) )
              = ( divide_divide @ A @ A2 @ B ) ) ) ) ) ).

% div_mult_mult1_if
thf(fact_222_div__mult__mult2,axiom,
    ! [A: $tType] :
      ( ( euclid191655569cancel @ A )
     => ! [C2: A,A2: A,B: A] :
          ( ( C2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ A2 @ C2 ) @ ( times_times @ A @ B @ C2 ) )
            = ( divide_divide @ A @ A2 @ B ) ) ) ) ).

% div_mult_mult2
thf(fact_223_div__mult__mult1,axiom,
    ! [A: $tType] :
      ( ( euclid191655569cancel @ A )
     => ! [C2: A,A2: A,B: A] :
          ( ( C2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ C2 @ A2 ) @ ( times_times @ A @ C2 @ B ) )
            = ( divide_divide @ A @ A2 @ B ) ) ) ) ).

% div_mult_mult1
thf(fact_224_mult__divide__mult__cancel__left__if,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [C2: A,A2: A,B: A] :
          ( ( ( C2
              = ( zero_zero @ A ) )
           => ( ( divide_divide @ A @ ( times_times @ A @ C2 @ A2 ) @ ( times_times @ A @ C2 @ B ) )
              = ( zero_zero @ A ) ) )
          & ( ( C2
             != ( zero_zero @ A ) )
           => ( ( divide_divide @ A @ ( times_times @ A @ C2 @ A2 ) @ ( times_times @ A @ C2 @ B ) )
              = ( divide_divide @ A @ A2 @ B ) ) ) ) ) ).

% mult_divide_mult_cancel_left_if
thf(fact_225_nonzero__mult__divide__mult__cancel__left,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [C2: A,A2: A,B: A] :
          ( ( C2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ C2 @ A2 ) @ ( times_times @ A @ C2 @ B ) )
            = ( divide_divide @ A @ A2 @ B ) ) ) ) ).

% nonzero_mult_divide_mult_cancel_left
thf(fact_226_nonzero__mult__divide__mult__cancel__left2,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [C2: A,A2: A,B: A] :
          ( ( C2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ C2 @ A2 ) @ ( times_times @ A @ B @ C2 ) )
            = ( divide_divide @ A @ A2 @ B ) ) ) ) ).

% nonzero_mult_divide_mult_cancel_left2
thf(fact_227_nonzero__mult__divide__mult__cancel__right,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [C2: A,A2: A,B: A] :
          ( ( C2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ A2 @ C2 ) @ ( times_times @ A @ B @ C2 ) )
            = ( divide_divide @ A @ A2 @ B ) ) ) ) ).

% nonzero_mult_divide_mult_cancel_right
thf(fact_228_nonzero__mult__divide__mult__cancel__right2,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [C2: A,A2: A,B: A] :
          ( ( C2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ A2 @ C2 ) @ ( times_times @ A @ C2 @ B ) )
            = ( divide_divide @ A @ A2 @ B ) ) ) ) ).

% nonzero_mult_divide_mult_cancel_right2
thf(fact_229_nonzero__mult__div__cancel__left,axiom,
    ! [A: $tType] :
      ( ( semidom_divide @ A )
     => ! [A2: A,B: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ A2 @ B ) @ A2 )
            = B ) ) ) ).

% nonzero_mult_div_cancel_left
thf(fact_230_nonzero__mult__div__cancel__right,axiom,
    ! [A: $tType] :
      ( ( semidom_divide @ A )
     => ! [B: A,A2: A] :
          ( ( B
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ A2 @ B ) @ B )
            = A2 ) ) ) ).

% nonzero_mult_div_cancel_right
thf(fact_231_not__real__square__gt__zero,axiom,
    ! [X: real] :
      ( ( ~ ( ord_less @ real @ ( zero_zero @ real ) @ ( times_times @ real @ X @ X ) ) )
      = ( X
        = ( zero_zero @ real ) ) ) ).

% not_real_square_gt_zero
thf(fact_232_nonzero__divide__mult__cancel__left,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [A2: A,B: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ A2 @ ( times_times @ A @ A2 @ B ) )
            = ( divide_divide @ A @ ( one_one @ A ) @ B ) ) ) ) ).

% nonzero_divide_mult_cancel_left
thf(fact_233_nonzero__divide__mult__cancel__right,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [B: A,A2: A] :
          ( ( B
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ B @ ( times_times @ A @ A2 @ B ) )
            = ( divide_divide @ A @ ( one_one @ A ) @ A2 ) ) ) ) ).

% nonzero_divide_mult_cancel_right
thf(fact_234_power__commutes,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A )
     => ! [A2: A,N: nat] :
          ( ( times_times @ A @ ( power_power @ A @ A2 @ N ) @ A2 )
          = ( times_times @ A @ A2 @ ( power_power @ A @ A2 @ N ) ) ) ) ).

% power_commutes
thf(fact_235_power__mult__distrib,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A )
     => ! [A2: A,B: A,N: nat] :
          ( ( power_power @ A @ ( times_times @ A @ A2 @ B ) @ N )
          = ( times_times @ A @ ( power_power @ A @ A2 @ N ) @ ( power_power @ A @ B @ N ) ) ) ) ).

% power_mult_distrib
thf(fact_236_power__commuting__commutes,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A )
     => ! [X: A,Y2: A,N: nat] :
          ( ( ( times_times @ A @ X @ Y2 )
            = ( times_times @ A @ Y2 @ X ) )
         => ( ( times_times @ A @ ( power_power @ A @ X @ N ) @ Y2 )
            = ( times_times @ A @ Y2 @ ( power_power @ A @ X @ N ) ) ) ) ) ).

% power_commuting_commutes
thf(fact_237_comm__monoid__mult__class_Omult__1,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A )
     => ! [A2: A] :
          ( ( times_times @ A @ ( one_one @ A ) @ A2 )
          = A2 ) ) ).

% comm_monoid_mult_class.mult_1
thf(fact_238_mult_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( one_one @ A ) )
          = A2 ) ) ).

% mult.comm_neutral
thf(fact_239_abs__mult,axiom,
    ! [A: $tType] :
      ( ( idom_abs_sgn @ A )
     => ! [A2: A,B: A] :
          ( ( abs_abs @ A @ ( times_times @ A @ A2 @ B ) )
          = ( times_times @ A @ ( abs_abs @ A @ A2 ) @ ( abs_abs @ A @ B ) ) ) ) ).

% abs_mult
thf(fact_240_mult__of__int__commute,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ! [X: int,Y2: A] :
          ( ( times_times @ A @ ( ring_1_of_int @ A @ X ) @ Y2 )
          = ( times_times @ A @ Y2 @ ( ring_1_of_int @ A @ X ) ) ) ) ).

% mult_of_int_commute
thf(fact_241_mult_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A )
     => ! [B: A,A2: A,C2: A] :
          ( ( times_times @ A @ B @ ( times_times @ A @ A2 @ C2 ) )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C2 ) ) ) ) ).

% mult.left_commute
thf(fact_242_mult_Ocommute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A )
     => ( ( times_times @ A )
        = ( ^ [A4: A,B2: A] : ( times_times @ A @ B2 @ A4 ) ) ) ) ).

% mult.commute
thf(fact_243_mult_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semigroup_mult @ A )
     => ! [A2: A,B: A,C2: A] :
          ( ( times_times @ A @ ( times_times @ A @ A2 @ B ) @ C2 )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C2 ) ) ) ) ).

% mult.assoc
thf(fact_244_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A )
     => ! [A2: A,B: A,C2: A] :
          ( ( times_times @ A @ ( times_times @ A @ A2 @ B ) @ C2 )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C2 ) ) ) ) ).

% ab_semigroup_mult_class.mult_ac(1)
thf(fact_245_mult__right__cancel,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A )
     => ! [C2: A,A2: A,B: A] :
          ( ( C2
           != ( zero_zero @ A ) )
         => ( ( ( times_times @ A @ A2 @ C2 )
              = ( times_times @ A @ B @ C2 ) )
            = ( A2 = B ) ) ) ) ).

% mult_right_cancel
thf(fact_246_mult__left__cancel,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A )
     => ! [C2: A,A2: A,B: A] :
          ( ( C2
           != ( zero_zero @ A ) )
         => ( ( ( times_times @ A @ C2 @ A2 )
              = ( times_times @ A @ C2 @ B ) )
            = ( A2 = B ) ) ) ) ).

% mult_left_cancel
thf(fact_247_no__zero__divisors,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A )
     => ! [A2: A,B: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( B
             != ( zero_zero @ A ) )
           => ( ( times_times @ A @ A2 @ B )
             != ( zero_zero @ A ) ) ) ) ) ).

% no_zero_divisors
thf(fact_248_divisors__zero,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A )
     => ! [A2: A,B: A] :
          ( ( ( times_times @ A @ A2 @ B )
            = ( zero_zero @ A ) )
         => ( ( A2
              = ( zero_zero @ A ) )
            | ( B
              = ( zero_zero @ A ) ) ) ) ) ).

% divisors_zero
thf(fact_249_mult__not__zero,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A )
     => ! [A2: A,B: A] :
          ( ( ( times_times @ A @ A2 @ B )
           != ( zero_zero @ A ) )
         => ( ( A2
             != ( zero_zero @ A ) )
            & ( B
             != ( zero_zero @ A ) ) ) ) ) ).

% mult_not_zero
thf(fact_250_abs__mult__less,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [A2: A,C2: A,B: A,D: A] :
          ( ( ord_less @ A @ ( abs_abs @ A @ A2 ) @ C2 )
         => ( ( ord_less @ A @ ( abs_abs @ A @ B ) @ D )
           => ( ord_less @ A @ ( times_times @ A @ ( abs_abs @ A @ A2 ) @ ( abs_abs @ A @ B ) ) @ ( times_times @ A @ C2 @ D ) ) ) ) ) ).

% abs_mult_less
thf(fact_251_left__right__inverse__power,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A )
     => ! [X: A,Y2: A,N: nat] :
          ( ( ( times_times @ A @ X @ Y2 )
            = ( one_one @ A ) )
         => ( ( times_times @ A @ ( power_power @ A @ X @ N ) @ ( power_power @ A @ Y2 @ N ) )
            = ( one_one @ A ) ) ) ) ).

% left_right_inverse_power
thf(fact_252_nonzero__eq__divide__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [C2: A,A2: A,B: A] :
          ( ( C2
           != ( zero_zero @ A ) )
         => ( ( A2
              = ( divide_divide @ A @ B @ C2 ) )
            = ( ( times_times @ A @ A2 @ C2 )
              = B ) ) ) ) ).

% nonzero_eq_divide_eq

% Type constructors (86)
thf(tcon_Int_Oint___Euclidean__Division_Oeuclidean__semiring__cancel,axiom,
    euclid191655569cancel @ int ).

thf(tcon_Int_Oint___Rings_Osemiring__no__zero__divisors__cancel,axiom,
    semiri1923998003cancel @ int ).

thf(tcon_Int_Oint___Rings_Osemiring__1__no__zero__divisors,axiom,
    semiri134348788visors @ int ).

thf(tcon_Int_Oint___Rings_Olinordered__nonzero__semiring,axiom,
    linord1659791738miring @ int ).

thf(tcon_Int_Oint___Rings_Osemiring__no__zero__divisors,axiom,
    semiri1193490041visors @ int ).

thf(tcon_Int_Oint___Groups_Oordered__ab__group__add__abs,axiom,
    ordere142940540dd_abs @ int ).

thf(tcon_Int_Oint___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add @ int ).

thf(tcon_Int_Oint___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors @ int ).

thf(tcon_Int_Oint___Groups_Ocancel__comm__monoid__add,axiom,
    cancel1352612707id_add @ int ).

thf(tcon_Int_Oint___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add @ int ).

thf(tcon_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom @ int ).

thf(tcon_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult @ int ).

thf(tcon_Int_Oint___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult @ int ).

thf(tcon_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom @ int ).

thf(tcon_Int_Oint___Groups_Osemigroup__mult,axiom,
    semigroup_mult @ int ).

thf(tcon_Int_Oint___Rings_Osemidom__divide,axiom,
    semidom_divide @ int ).

thf(tcon_Int_Oint___Parity_Osemiring__bits,axiom,
    semiring_bits @ int ).

thf(tcon_Int_Oint___Rings_Ozero__less__one,axiom,
    zero_less_one @ int ).

thf(tcon_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one @ int ).

thf(tcon_Int_Oint___Rings_Oidom__abs__sgn,axiom,
    idom_abs_sgn @ int ).

thf(tcon_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult @ int ).

thf(tcon_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1 @ int ).

thf(tcon_Int_Oint___Groups_Ogroup__add,axiom,
    group_add @ int ).

thf(tcon_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero @ int ).

thf(tcon_Int_Oint___Num_Oneg__numeral,axiom,
    neg_numeral @ int ).

thf(tcon_Int_Oint___Nat_Oring__char__0,axiom,
    ring_char_0 @ int ).

thf(tcon_Int_Oint___Rings_Oring__1,axiom,
    ring_1 @ int ).

thf(tcon_Int_Oint___Power_Opower,axiom,
    power @ int ).

thf(tcon_Int_Oint___Groups_Ozero,axiom,
    zero @ int ).

thf(tcon_Int_Oint___Groups_Oone,axiom,
    one @ int ).

thf(tcon_Nat_Onat___Euclidean__Division_Oeuclidean__semiring__cancel_1,axiom,
    euclid191655569cancel @ nat ).

thf(tcon_Nat_Onat___Rings_Osemiring__no__zero__divisors__cancel_2,axiom,
    semiri1923998003cancel @ nat ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat ).

thf(tcon_Nat_Onat___Rings_Osemiring__1__no__zero__divisors_3,axiom,
    semiri134348788visors @ nat ).

thf(tcon_Nat_Onat___Rings_Olinordered__nonzero__semiring_4,axiom,
    linord1659791738miring @ nat ).

thf(tcon_Nat_Onat___Rings_Osemiring__no__zero__divisors_5,axiom,
    semiri1193490041visors @ nat ).

thf(tcon_Nat_Onat___Groups_Ocancel__ab__semigroup__add_6,axiom,
    cancel146912293up_add @ nat ).

thf(tcon_Nat_Onat___Groups_Ocancel__comm__monoid__add_7,axiom,
    cancel1352612707id_add @ nat ).

thf(tcon_Nat_Onat___Rings_Olinordered__semidom_8,axiom,
    linordered_semidom @ nat ).

thf(tcon_Nat_Onat___Groups_Oab__semigroup__mult_9,axiom,
    ab_semigroup_mult @ nat ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__mult_10,axiom,
    comm_monoid_mult @ nat ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__diff,axiom,
    comm_monoid_diff @ nat ).

thf(tcon_Nat_Onat___Groups_Osemigroup__mult_11,axiom,
    semigroup_mult @ nat ).

thf(tcon_Nat_Onat___Rings_Osemidom__divide_12,axiom,
    semidom_divide @ nat ).

thf(tcon_Nat_Onat___Parity_Osemiring__bits_13,axiom,
    semiring_bits @ nat ).

thf(tcon_Nat_Onat___Rings_Ozero__less__one_14,axiom,
    zero_less_one @ nat ).

thf(tcon_Nat_Onat___Orderings_Owellorder,axiom,
    wellorder @ nat ).

thf(tcon_Nat_Onat___Rings_Ozero__neq__one_15,axiom,
    zero_neq_one @ nat ).

thf(tcon_Nat_Onat___Groups_Omonoid__mult_16,axiom,
    monoid_mult @ nat ).

thf(tcon_Nat_Onat___Rings_Osemiring__1_17,axiom,
    semiring_1 @ nat ).

thf(tcon_Nat_Onat___Rings_Omult__zero_18,axiom,
    mult_zero @ nat ).

thf(tcon_Nat_Onat___Power_Opower_19,axiom,
    power @ nat ).

thf(tcon_Nat_Onat___Groups_Ozero_20,axiom,
    zero @ nat ).

thf(tcon_Nat_Onat___Groups_Oone_21,axiom,
    one @ nat ).

thf(tcon_Real_Oreal___Rings_Osemiring__no__zero__divisors__cancel_22,axiom,
    semiri1923998003cancel @ real ).

thf(tcon_Real_Oreal___Rings_Osemiring__1__no__zero__divisors_23,axiom,
    semiri134348788visors @ real ).

thf(tcon_Real_Oreal___Rings_Olinordered__nonzero__semiring_24,axiom,
    linord1659791738miring @ real ).

thf(tcon_Real_Oreal___Rings_Osemiring__no__zero__divisors_25,axiom,
    semiri1193490041visors @ real ).

thf(tcon_Real_Oreal___Groups_Oordered__ab__group__add__abs_26,axiom,
    ordere142940540dd_abs @ real ).

thf(tcon_Real_Oreal___Groups_Ocancel__ab__semigroup__add_27,axiom,
    cancel146912293up_add @ real ).

thf(tcon_Real_Oreal___Rings_Oring__1__no__zero__divisors_28,axiom,
    ring_11004092258visors @ real ).

thf(tcon_Real_Oreal___Groups_Ocancel__comm__monoid__add_29,axiom,
    cancel1352612707id_add @ real ).

thf(tcon_Real_Oreal___Groups_Oordered__ab__group__add_30,axiom,
    ordered_ab_group_add @ real ).

thf(tcon_Real_Oreal___Rings_Olinordered__semidom_31,axiom,
    linordered_semidom @ real ).

thf(tcon_Real_Oreal___Groups_Oab__semigroup__mult_32,axiom,
    ab_semigroup_mult @ real ).

thf(tcon_Real_Oreal___Groups_Ocomm__monoid__mult_33,axiom,
    comm_monoid_mult @ real ).

thf(tcon_Real_Oreal___Fields_Olinordered__field,axiom,
    linordered_field @ real ).

thf(tcon_Real_Oreal___Rings_Olinordered__idom_34,axiom,
    linordered_idom @ real ).

thf(tcon_Real_Oreal___Groups_Osemigroup__mult_35,axiom,
    semigroup_mult @ real ).

thf(tcon_Real_Oreal___Rings_Osemidom__divide_36,axiom,
    semidom_divide @ real ).

thf(tcon_Real_Oreal___Fields_Ofield__abs__sgn,axiom,
    field_abs_sgn @ real ).

thf(tcon_Real_Oreal___Fields_Odivision__ring,axiom,
    division_ring @ real ).

thf(tcon_Real_Oreal___Rings_Ozero__less__one_37,axiom,
    zero_less_one @ real ).

thf(tcon_Real_Oreal___Rings_Ozero__neq__one_38,axiom,
    zero_neq_one @ real ).

thf(tcon_Real_Oreal___Rings_Oidom__abs__sgn_39,axiom,
    idom_abs_sgn @ real ).

thf(tcon_Real_Oreal___Groups_Omonoid__mult_40,axiom,
    monoid_mult @ real ).

thf(tcon_Real_Oreal___Rings_Osemiring__1_41,axiom,
    semiring_1 @ real ).

thf(tcon_Real_Oreal___Groups_Ogroup__add_42,axiom,
    group_add @ real ).

thf(tcon_Real_Oreal___Rings_Omult__zero_43,axiom,
    mult_zero @ real ).

thf(tcon_Real_Oreal___Num_Oneg__numeral_44,axiom,
    neg_numeral @ real ).

thf(tcon_Real_Oreal___Nat_Oring__char__0_45,axiom,
    ring_char_0 @ real ).

thf(tcon_Real_Oreal___Rings_Oring__1_46,axiom,
    ring_1 @ real ).

thf(tcon_Real_Oreal___Fields_Ofield,axiom,
    field @ real ).

thf(tcon_Real_Oreal___Power_Opower_47,axiom,
    power @ real ).

thf(tcon_Real_Oreal___Groups_Ozero_48,axiom,
    zero @ real ).

thf(tcon_Real_Oreal___Groups_Oone_49,axiom,
    one @ real ).

% Conjectures (1)
thf(conj_0,conjecture,
    $false ).

%------------------------------------------------------------------------------
